// Rad_Style.js //

/*
	The Style object, used by most of the rad classes.
	
	 - Specifying nothing means the style will use Spheres
	defaults.
*/

function Style(windowStyle, font, arrow, upArrow, downArrow, cursor)
{
	if (!this instanceof Style)
	return new Style(windowStyle, font, arrow, upArrow, downArrow, cursor);
	
	this.window      = windowStyle || GetSystemWindowStyle();
	this.font        = font        || GetSystemFont();
	this.arrow       = arrow       || LoadImage("RadLib/Arrow.png")
	this.upArrow     = upArrow     || GetSystemUpArrow();
	this.downArrow   = downArrow   || GetSystemDownArrow();
	this.cursor      = cursor      || LoadImage("RadLib/Cursor.png");
	this.borderText  = true;
	this.borderColor = Colors.black;
	this.fontColor   = Colors.white;
	this.colorUp     = Colors.white;
	this.colorDown   = CreateColor(80, 80, 170);
	this.borderSize  = 16;
}

// Draws the text: txt, at x, y, with a border (if set).
Style.prototype.drawText = function(x, y, text)
{
	if (this.borderText) {
		DrawBorderedText(this.font, this.fontColor, this.borderColor, x, y, text);
	}
	else {
		font.setColorMask(this.fontColor);
		font.drawText(x, y, text);
	}
}

function DrawBorderedText(font, f_color, b_color, x, y, text) {
	font.setColorMask(b_color);
	font.drawText(x-1, y, text);
	font.drawText(x+1, y, text);
	font.drawText(x, y-1, text);
	font.drawText(x, y+1, text);
	font.setColorMask(f_color);
	font.drawText(x, y, text);
}